//
//  AppDelegate_Sync.m
//  Kyopon Schedule Sync
//
//  Created by FUJIDANA on 06/09/18.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import "AppDelegate.h"
#import <SyncServices/SyncServices.h>
#import "WXKProgressWindowController.h"


@implementation AppDelegate (Sync)

- (id <WXKSyncing>)syncController
{
	return _syncController;
}

- (void)setSyncController:(id <WXKSyncing>)value
{
	_syncController = value;
}

- (IBAction)sync:(id)sender
{
//	NSError *error;
//	if ([[self managedObjectContext] save:&error] == NO) {
//		[NSApp presentError:error];
//		return;
//	}
//
//	[[window undoManager] removeAllActions];
	
	if (_syncController == nil) {
		NSLog(@"Sync Controller is not set.");
		return;
	}
	
	if ([[ISyncManager sharedManager] isEnabled] == NO) {
		NSLog(@"Sync Manager is disabled");
		NSBeep();
		return;
	}
	
	NSArray *syncFilters = [_syncController syncFilters];
	if (syncFilters) {
		[[_syncController syncClient] setFilters:syncFilters];
	}
	
	_progressWindowController = [[WXKProgressWindowController alloc] initWithParentWindow:window];
	[_progressWindowController beginProgressWithMessage:@"Waiting Other Clients to be ready to Sync..."];
	
	[ISyncSession beginSessionInBackgroundWithClient:[_syncController syncClient]
										 entityNames:[[_syncController syncClient] enabledEntityNames]
											  target:self
											selector:@selector(sessionInBackgroundDidBeginWithClient:session:)];
}

@end


#pragma mark -


@implementation AppDelegate (Sync_Private)


- (void)sessionInBackgroundDidBeginWithClient:(ISyncClient *)client session:(ISyncSession *)session
{
	[_progressWindowController setMessage:@"Negotiating..."];
	
	NSEnumerator *entityNamesEnumerator;
	NSString     *entityName;
	
	// 2. Pushing...
	
	[_progressWindowController setMessage:@"Pushing..."];
	
	entityNamesEnumerator = [[client enabledEntityNames] objectEnumerator];
	while (entityName = [entityNamesEnumerator nextObject]) {
		if ([session shouldPushAllRecordsForEntityName:entityName]) {
			// slow sync...
			NSLog(@"Unable to push entity: %@", entityName);
		} else if ([session shouldPushChangesForEntityName:entityName]) {
			// fast sync...
			NSLog(@"Unable to push entity: %@", entityName);
		}
	}
	
	// 3. Mingling...
	
	[_progressWindowController setMessage:@"Mingling..."];
	
	if ([session prepareToPullChangesForEntityNames:[client enabledEntityNames] 
										 beforeDate:[NSDate distantFuture]] == NO) {
		NSLog(@"Not prepared to pull changes");
	}
//	[session prepareToPullChangesInBackgroundForEntityNames:[[_syncController syncClient] enabledEntityNames]
//													 target:self
//												   selector:@selector(sessionDidPrepareToPullChangesWithClient:session:)];
//	
//}
//
//- (void)sessionDidPrepareToPullChangesWithClient:(ISyncClient *)client session:(ISyncSession *)session
//{
//	NSEnumerator *entityNamesEnumerator;
//	NSString     *entityName;
	
	// 4. Pulling...
	
	[_progressWindowController setMessage:@"Pulling..."];
	
	// 4. 1. Pull changes?
	entityNamesEnumerator = [[client enabledEntityNames] objectEnumerator];
	NSMutableArray *filteredEntityNames = [NSMutableArray arrayWithCapacity:[[client enabledEntityNames] count]];
	
	while (entityName = [entityNamesEnumerator nextObject]) {
		if ([session shouldPullChangesForEntityName:entityName]) {
			[filteredEntityNames addObject:entityName];
		}
	}
	
	// 4. 2. Replace all records?
	entityNamesEnumerator = [[client enabledEntityNames] objectEnumerator];
	
	while (entityName = [entityNamesEnumerator nextObject]) {
		if ([session shouldReplaceAllRecordsOnClientForEntityName:entityName]) {
			[_syncController removeAllLocalRecordsOfEntityName:entityName];
		}
	}
	
	// 4. 3. Pull changes
	
	[_syncController acceptOrDenyChangesWithEntityNames:[[_syncController syncClient] enabledEntityNames] session:session];
	
	// 5. Finishing...
	
	[_progressWindowController setMessage:@"Finishing..."];
	
	[session clientCommittedAcceptedChanges];
	[session finishSyncing];
	
	[_progressWindowController endProgress];
	[_progressWindowController release], _progressWindowController = nil;
	
	[[self managedObjectContext] processPendingChanges];
	[arrayController rearrangeObjects];
}

@end
